DEFINT A-Z
'$INCLUDE: '64blaz.bi'
DECLARE SUB ClearBlk (BTop%, BLeft%, BBot%, BRight%, BFore%, BBack%)
DECLARE SUB Put40 (CurFlag%)
DECLARE SUB Waitt (Delay&, Keyy%)
DECLARE SUB GetaKey (Keyy$)
DECLARE SUB TRead (Messg$)
DECLARE SUB XMessage (MsgNum%)
DECLARE SUB XUpdate (FilePos&)
DECLARE SUB XInitWin ()
DECLARE SUB XAskFile ()
DECLARE SUB XFileErr (ErrCode%)
DECLARE FUNCTION CCap$ (Strg$)      'String capitalization, so always in caps
                                    'regardless of the current C64 char set
DECLARE FUNCTION TimeDiff& (Mark&)  'Tells time difference between now and
                                    'the time in Mark&, in seconds times 100
DECLARE FUNCTION Time& ()           'Returns no. of seconds, multiplied by
                                    '100, since midnight (no real numbers!)

'The following is the colors used for the Xmodem transfer status window.
CONST XBack% = 6    'Color of the status window background
CONST XC1% = 3      'Color of the title of the status window
CONST XC2% = 15     'Color of words referring to numbers (ie TIME:)
CONST XC3% = 1      'Color of numbers displayed in status window (ie 01:24)
CONST XC4% = 13     'Color of horizontal divider right above status messages
CONST XC5% = 7      'Color of status messages
CONST XC6% = 10     'Color of filename error message
'The following is the Xmodem transfer parameters. For duration parameters,
'they are in TIME& function's format, in seconds multiplied by 100.
CONST XInitWait& = 1000   'Duration between download initiation codes
CONST XRetryLim& = 1000   'Duration of no chars from remote in download
                          'before sending a NAK (bad Xmodem block) code.
CONST XBeginLim& = 6000   'Duration of initiation before timeout
CONST XEndLim& = 600      'Delay between End Of Transfer codes
CONST XBeginWarn& = 4000  'Delay at initiation before displaying warning msg
CONST XGarbLim& = 1000    'Duration of continous nonesense garbage in
                          'file transfer before aborting
CONST XBadCharLim& = 2000 'Number of bad characters at download initiation
                          'before aborting transfer attempt
CONST XBeginRevert% = 3   'Number of download initiation codes before
                          'reverting to Checksum from CRC
CONST EOT$ = ""          'Code 4, End Of Transfer code
CONST ACK$ = ""          'Code 6, for accepted Xmodem block
CONST NAK$ = ""          'Code 21, for bad Xmodem block
CONST CAN$ = ""          'Code 24, Ctrl-X Abort code

DIM SHARED LineBuff AS STRING * 80

BadFile:
FileErr% = -1
RESUME NEXT

SUB XAskFile
  XFore% = 15
  Colr% = XFore%
  IF XFer% > 0 THEN Msg$ = "  Upload File:" ELSE Msg$ = "Download File:"
  ClearBlk 11, 1, 13, 40, XFore%, XBack%
  Print64 12, 2, Fo(XFore%) + Ba(XBack%) + CCap$(Msg$)
  LLeft% = 2 + LEN(Msg$)
  Offs% = 1
  LOCATE 12, LLeft% + Offs%, 1, 0, 7
  Maxx% = 23
  XFile$ = ""
  DO
    GetaKey Keyy$
    Keyy$ = CCap$(Keyy$)
    IF Keyy$ = "\" THEN Keyy$ = "/"
    IF Keyy$ >= " " AND Keyy$ <= "~" AND Offs% < 64 THEN
      XFile$ = XFile$ + Keyy$
      IF Offs% <= Maxx% THEN
        Print64 12, LLeft% + Offs%, Keyy$
        LOCATE , LLeft% + Offs% + 1
      ELSE
        Print64 12, LLeft% + 1, "..." + RIGHT$(XFile$, Maxx% - 3)
        'Print64 12, LLeft% + Maxx%, Keyy$
        LOCATE , LLeft% + Maxx% + 1
      END IF
      Offs% = Offs% + 1
    ELSEIF Keyy$ = CHR$(8) AND Offs% > 1 THEN
      XFile$ = LEFT$(XFile$, LEN(XFile$) - 1)
      Offs% = Offs% - 1
      IF Offs% <= Maxx% THEN
        Print64 12, LLeft% + Offs%, " "
        LOCATE , LLeft% + Offs%
      ELSE
        IF Offs% = Maxx% + 1 THEN
          Print64 12, LLeft% + 1, XFile$
        ELSE
          Print64 12, LLeft% + 4, RIGHT$(XFile$, Maxx% - 3)
        END IF
        LOCATE , LLeft% + Maxx% + 1
      END IF
    ELSEIF Keyy$ = CHR$(13) THEN
      EXIT DO
    ELSEIF Keyy$ = CHR$(27) THEN
      XFile$ = ""
      EXIT DO
    END IF
  LOOP
  LOCATE , , 0, 9, 9

END SUB

SUB XFileErr (ErrCode%)
  ClearBlk 11, 1, 13, 40, XFore%, XBack%
  SELECT CASE ErrCode%
  CASE 1: Print64 12, 8, Fo(XC6%) + CCap$("Error: File already exists")
  CASE 2: Print64 12, 11, Fo(XC6%) + CCap$("Error: Bad filename")
  END SELECT
  Waitt 250, 1        '2.5 seconds
END SUB

SUB XInitWin
  Put40 0
  ClearBlk 8, 5, 18, 36, XC1%, XBack%
  Print64 1, 1, Fo(XC1%) + Ba(XBack%)
  IF XFer% > 0 THEN
    Print64 8, 7, CCap$("xmodem upload: esc to abort")
  ELSEIF XFer% < 0 THEN
    Print64 8, 6, CCap$("xmodem download: esc to abort")
  END IF
  Row% = 10
  Print64 10, 6, Fo(XC2%) + CCap$("file: ")
  PFile$ = XFile$
  IF LEN(PFile$) > 24 THEN PFile$ = "..." + RIGHT$(PFile$, 21)
  Print64 10, 12, Fo(XC3%) + CCap$(PFile$)
  Print64 11, 6, Fo(XC2%) + CCap$("time:")
  Print64 12, 6, CCap$(" cps:")
  Print64 11, 24, CCap$("size:")
  IF XFer% > 0 AND XFreeF% <> 0 THEN Print64 11, 29, Fo(XC3%) + STR$(LOF(XFreeF%)) + Fo(XC2%)
  Print64 12, 24, CCap$(" pos:")
  Print64 14, 5, "`        ````````         ``````"
  Print64 14, 6, CCap$("messages")
  Print64 14, 22, CCap$("errors: ")
  Print64 14, 30, Fo(XC3%) + "0"
  XTotalErr% = 0

END SUB

SUB XMessage (MsgNum%)
  SELECT CASE MsgNum%
  CASE -10: MM$ = "** Abort at console **"
  CASE -11: MM$ = "** Carrier lost **"
  CASE -12: MM$ = "** Abort by remote **"
  CASE -13: MM$ = "** Too many errors **"
  CASE -14: MM$ = "** Too many duplicate blocks **"
  CASE -15: MM$ = "** Timeout **"
  CASE -16: MM$ = "** Non-stop garbage **"
  CASE -6:  MM$ = "Empty file recieved"
  CASE -5:  MM$ = "Transfer completed"
  CASE -1:  MM$ = "Transfer completed"
  CASE 1:   MM$ = ">> Duplicate block" + STR$(XBlockNum%) + " <<"
  CASE 2:   MM$ = ">> NAK for block" + STR$(XBlockNum%) + " <<"
  CASE 3:   MM$ = "Initiating transfer..."
  CASE 4:   MM$ = "Sending file"
  CASE 5:   MM$ = "Recieving file"
  CASE 6:   MM$ = "Waiting for remote..."
  CASE 8:   MM$ = "Checksum mode"
  CASE 9:   MM$ = "CRC mode"
  CASE 10:  MM$ = ">> Remote not responding <<"
  CASE 11:  MM$ = "Sending file, CRC mode"
  CASE 12:  MM$ = "Sending file, Checksum mode"
  CASE 13:  MM$ = "Recieving file, CRC mode"
  CASE 14:  MM$ = "Recieving file, Checksum mode"
  END SELECT
  Regs.ax = &H601
  Regs.bx = VAL("&H" + HEX$(XBack% * 4096& + XC5% * 256&))
  Regs.cx = (15 - 1) * 256 + 5 - 1
  Regs.dx = (18 - 1) * 256 + 36 - 1
  interrupt &H10, Regs, Regs
  IF Set% = 0 THEN MM$ = LCASE$(MM$)
  MM$ = LEFT$(MM$ + SPACE$(40), 30)
  Print64 18, 6, Fo(XC5%) + MM$
  SELECT CASE MsgNum%
  CASE 1, 2, 10
    XTotalErr% = XTotalErr% + 1
    Print64 14, 29, Fo(XC3%) + STR$(XTotalErr%)
  CASE IS < 0
    Temp& = LOF(XFreeF%)
    CLOSE XFreeF%
    IF Temp& = 0 AND XFer% < 0 THEN
      KILL XFile$
    END IF
    IF MsgNum% <= -5 THEN
      SOUND 300, .1
      SOUND 450, .2
      SOUND 600, .5
      Eatt& = Time&
      Tempp& = Time&
      DO
        IF XFer% > 0 THEN
          TRead Char$
          IF LEN(Char$) THEN Eatt& = Time&
        END IF
        IF TCOutStat% THEN Eatt& = Time&
        IF TimeDiff&(Tempp&) > 500 THEN EXIT DO
      LOOP UNTIL TimeDiff&(Eatt&) > 50 OR TimeDiff&(Tempp&) > 500
      FOR Abort% = 1 TO 4
        TCWrite CAN$
        Waitt 25, 0       '.25 second
      NEXT Abort%
      Waitt 120, 1        '1.2 second
    ELSE
      Waitt 250, 1        '2.5 seconds
    END IF
  END SELECT
END SUB

SUB XmodemRec
  XAskFile
  IF LEN(XFile$) = 0 THEN EXIT SUB
  TCFlushIn
  XFreeF% = FREEFILE
  FileErr% = 0
  ON ERROR GOTO BadFile
  OPEN XFile$ FOR INPUT AS #XFreeF%
  CLOSE #XFreeF%
  IF FileErr% = 0 THEN XFileErr 1: EXIT SUB
  FileErr% = 0
  OPEN XFile$ FOR BINARY AS #XFreeF%
  IF FileErr% THEN XFileErr 2: EXIT SUB
  ON ERROR GOTO 0
  XInitWin
  IF TCCarrier% = 0 THEN XMessage -11: EXIT SUB
  XBlock$ = ""
  XDupe% = 0
  XInitiate% = 0
  XBlockNum% = 1
  XStop% = 0
  XWarned% = 0
  XMessage 3
  XStarted% = 0
  XFinished% = 0
  XTimeOut& = Time&
  XStart& = Time& - XInitWait& - 100
  DO
    IF INKEY$ = CHR$(27) THEN XMessage -10: EXIT SUB
    IF TCCarrier% = 0 THEN XMessage -11: EXIT SUB
    IF TimeDiff&(XStart&) > XInitWait& THEN
      IF TimeDiff&(XTimeOut&) > XBeginLim& THEN XMessage -15: EXIT SUB
      XErrors% = 0
      IF XInitiate% = XBeginRevert% AND XFer% = -2 THEN XFer% = -1: XMessage 8
      XInitiate% = XInitiate% + 1
      SELECT CASE XFer%
      CASE -1: TCWrite NAK$
      CASE -2: TCWrite "C"
      END SELECT
      IF TimeDiff&(XTimeOut&) > XBeginWarn& AND XWarned% = 0 THEN XMessage 10: XWarned% = -1
      XStart& = Time&
    END IF
    Char$ = TCInkey$
    IF Char$ = CHR$(1) OR (Char$ = CHR$(2) AND XFer% = -2) THEN
      EXIT DO
    ELSEIF Char$ = CAN$ THEN
      XStop% = XStop% + 1
      IF XStop% = 2 THEN XMessage -12: EXIT SUB
    ELSEIF Char$ = EOT$ THEN
      XTimeOut& = Time&
      IF XFinished% = 0 THEN
        TCWrite NAK$
        XFinished% = XFinished% - 1
      ELSE
        TCWrite ACK$
        XMessage -6
        EXIT SUB
      END IF
    ELSEIF LEN(Char$) THEN
      IF XErrors% = 0 THEN XErrorChars& = Time&
      XErrors% = XErrors% + 1
      IF XErrors% AND TimeDiff&(XErrorChars&) > XBadCharLim& THEN XMessage -16: EXIT SUB
    ELSE
      IF TimeDiff&(XErrorChars&) > 50 THEN XErrors% = 0: XErrorChars& = Time&
    END IF
  LOOP
  IF Char$ = CHR$(1) THEN
    XBlockSize% = 128
    XPacketSize% = 132
    IF XFer% = -2 THEN XPacketSize% = 133
  ELSE
    XBlockSize% = 1024
    XPacketSize% = 1029
  END IF
  XErrors% = 0
  XBlock$ = Char$
  XStop% = 0
  IF XFer% = -2 THEN XMessage 13 ELSE XMessage 14  '13CRC 14Cksum
  XBegin& = Time&
  XUpdate 0
  XBegin& = Time&
  XTimeOut& = Time&
  DO
    IF LEN(XBlock$) = 0 THEN
      Char$ = TCInkey$
      IF Char$ = EOT$ THEN
        TCWrite NAK$
        XTimeOut& = Time&
        EXIT DO
      ELSEIF LEN(Char$) THEN
        IF XFer% = -2 THEN
          IF Char$ = CHR$(1) OR Char$ <> CHR$(2) THEN
            XBlockSize% = 128
            XPacketSize% = 133
          ELSEIF Char$ = CHR$(2) THEN
            XBlockSize% = 1024
            XPacketSize% = 1029
          END IF
        END IF
        XBlock$ = Char$
      END IF
    END IF
    IF LEN(XBlock$) THEN
      TRead Blockk$
      IF LEN(Blockk$) OR LEN(XBlock$) >= XPacketSize% THEN
        XBlock$ = XBlock$ + Blockk$
        IF LEFT$(XBlock$, 2) = CAN$ + CAN$ THEN XMessage -12: EXIT SUB
        XTimeOut& = Time&
        XStart& = Time&
        IF LEN(XBlock$) >= XPacketSize% THEN
          XFileData$ = MID$(XBlock$, 4, XBlockSize%)
          BLK% = ASC(MID$(XBlock$, 2, 1))
          IF BLK% + ASC(MID$(XBlock$, 3, 1)) <> 255 THEN
            XErred% = 1
          ELSEIF LEFT$(XBlock$, 1) <> CHR$(1) AND LEFT$(XBlock$, 1) <> CHR$(2) THEN
            XErred% = 1
          ELSEIF XFer% = -1 THEN
            Checksum XFileData$, Chk%
            IF Chk% <> ASC(MID$(XBlock$, XPacketSize%, 1)) THEN XErred% = 1
          ELSE
            CRC XFileData$ + MID$(XBlock$, XPacketSize% - 1, 2), Msb%, Lsb%
            IF Lsb% OR Msb% THEN XErred% = 1
          END IF
          IF XErred% THEN
            XMessage 2
            XDupe% = 0
            XErrors% = XErrors% + 1
            XNakTimeout& = Time&
          ELSE
            BlockCheck% = XBlockNum% AND 255
            IF BlockCheck% = BLK% THEN
              TCFlushIn
              TCWrite ACK$
              LenFile& = LOF(XFreeF%)
              PUT #XFreeF%, LenFile& + 1, XFileData$
              XUpdate LOF(XFreeF%)
              XBlockNum% = XBlockNum% + 1
              XDupe% = 0
              XErrors% = 0
            ELSEIF BlockCheck% = ((BLK% + 1) AND 255) THEN
              IF XDupe% = 10 THEN XMessage -14: EXIT SUB
              XMessage 1
              XDupe% = XDupe% + 1
              TCWrite ACK$
              XErrors% = 0
            ELSE
              XErred% = 1
              XMessage 2
              XDupe% = 0
              XErrors% = XErrors% + 1
              XNakTimeout& = Time&
            END IF
          END IF
          IF XErrors% > 10 THEN XMessage -13: EXIT SUB
          IF XErred% THEN
            GarbTime& = Time&
            DO
              TRead Garb$
              IF INSTR(Garb$, CAN$ + CAN$) THEN
                XMessage -12: EXIT SUB
              ELSEIF XStop% = 0 AND RIGHT$(Garb$, 1) = CAN$ THEN
                XStop% = 1
              ELSEIF XStop% = 1 AND LEFT$(Garb$, 1) = CAN$ THEN
                XMessage -12: EXIT SUB
              ELSEIF TimeDiff&(GarbTime&) > XGarbLim& THEN
                XMessage -16: EXIT SUB
              ELSEIF LEN(Garb$) THEN
                XNakTimeout& = Time&
                XStop% = 0
              END IF
            LOOP UNTIL TimeDiff&(XNakTimeout&) > 50     '.5 second
            XErred% = 0
            TCWrite NAK$
            XTimeOut& = Time&
          END IF
          XBlock$ = ""
        END IF
      END IF
    END IF
    IF TimeDiff&(XTimeOut&) > XRetryLim& THEN
      IF TimeDiff&(XStart&) > XBeginLim& THEN
        IF XErred% THEN XMessage -16 ELSE XMessage -15
      ELSEIF XErred% = 0 THEN
        IF LEN(XBlock$) = 132 AND XBlockNum% = 1 THEN
          XFer% = -1
          XBlockSize% = 128
          XPacketSize% = 132
          XMessage 8
        ELSE
          XBlock$ = ""
          XMessage 2
          TCWrite NAK$
        END IF
        XTimeOut& = Time&
      END IF
    END IF
    IF TCCarrier% = 0 THEN XMessage -11: EXIT SUB
    IF INKEY$ = CHR$(27) THEN XMessage -10: EXIT SUB
  LOOP
  XErrors% = 0
  XStop% = 0
  XTimeOut& = Time&
  DO
    IF INKEY$ = CHR$(27) THEN XMessage -10: EXIT SUB
    IF TCCarrier% = 0 THEN XMessage -5: XMessage -11: EXIT SUB
    Char$ = TCInkey$
    IF Char$ = EOT$ THEN
      TCWrite ACK$
      XMessage -1: EXIT DO
    ELSEIF LEN(Char$) OR TimeDiff&(XTimeOut&) > XEndLim& THEN
      XErrors% = XErrors% + 1
      IF XErrors% >= 10 THEN
        TCWrite ACK$
        XMessage -5: EXIT DO
      END IF
      TCWrite NAK$
      XStop% = 0
      XTimeOut& = Time&
    ELSEIF Char$ = CAN$ THEN
      XStop% = XStop% + 1
      IF XStop% = 2 THEN XMessage -5: EXIT DO
    END IF
  LOOP
END SUB

SUB XmodemSend
  XAskFile
  IF LEN(XFile$) = 0 THEN EXIT SUB
  TCFlushIn
  XFreeF% = FREEFILE
  FileErr% = 0
  ON ERROR GOTO BadFile
  OPEN XFile$ FOR INPUT AS #XFreeF%
  CLOSE #XFreeF%
  IF FileErr% THEN XFileErr 2: EXIT SUB
  ON ERROR GOTO 0
  OPEN XFile$ FOR BINARY AS #XFreeF%
  XInitWin
  IF TCCarrier% = 0 THEN XMessage -11: EXIT SUB
  TCFlushIn
  XFileSize& = LOF(XFreeF%)
  XBlockNum% = 0
  XFilePos& = 0
  XBlock$ = ""
  XBlockk$ = ""
  XNextBlock$ = ""
  XFilePos& = 0
  XErrors% = 0
  XStop% = 0
  XMode% = 0
  XWarned% = 0
  XSendBlock% = -1
  XMessage 6
  XTimeOut& = Time&
  DO
    IF TCCarrier% = 0 THEN XMessage -11: EXIT SUB
    IF INKEY$ = CHR$(27) THEN XMessage -10: EXIT SUB
    IF TimeDiff&(XTimeOut&) > XBeginWarn& AND XWarned% = 0 THEN XMessage 10: XWarned% = -1
    IF TimeDiff&(XTimeOut&) > XBeginLim& THEN XMessage -15: EXIT SUB
    Char$ = TCInkey$
    IF LEN(Char$) THEN
      IF Char$ = NAK$ THEN
        IF XFer% = 2 THEN XFer% = 1
        XMessage 12
        XMode% = 0
        XBlockSize% = 128
        EXIT DO
      ELSEIF Char$ = "C" THEN
        XMessage 11
        XMode% = 1
        IF XFer% = 1 THEN
          XBlockSize% = 128
        ELSE
          IF XFileSize& - XFilePos& + 128 <= 1024 THEN
            XBlockSize% = 128
          ELSE
            XBlockSize% = 1024
          END IF
        END IF
        EXIT DO
      ELSEIF Char$ = CAN$ THEN
        XStop% = XStop% + 1
        IF XStop% = 2 THEN XMessage -12: EXIT SUB
      END IF
    END IF
  LOOP
  XSendBlock% = -1
  XBegin& = Time&
  XUpdate 0
  XBegin& = Time&
  XTimeOut& = Time&
  DO
    IF TCCarrier% = 0 THEN XMessage -11: EXIT SUB
    IF INKEY$ = CHR$(27) THEN XMessage -10: EXIT SUB
    IF XSendBlock% THEN
      XSendBlock% = 0
      IF XFilePos& + XBlockSize% < XFileSize& THEN
        IF LEN(XBlockk$) THEN
          SEEK #XFreeF%, XFilePos& + 1 + XBlockSize%
        ELSE
          SEEK #XFreeF%, XFilePos& + 1
        END IF
        XNextBlock$ = INPUT$(XBlockSize%, XFreeF%)
        IF LEN(NextBlock$) < XBlockSize% THEN
          XNextBlock$ = XNextBlock$ + STRING$(XBlockSize% - LEN(XNextBlock$), CHR$(26))
        END IF
        IF XMode% = 0 THEN
          Chk% = 0
          Checksum XNextBlock$, Chk%
          XNextBlock$ = XNextBlock$ + CHR$(Chk%)
        ELSE
          Msb% = 0
          Lsb% = 0
          CRC XNextBlock$ + CHR$(0) + CHR$(0), Msb%, Lsb%
          XNextBlock$ = XNextBlock$ + CHR$(Msb%) + CHR$(Lsb%)
        END IF
        BLK% = (XBlockNum% + 1) AND 255
        XNextBlock$ = CHR$(BLK%) + CHR$(255 - BLK%) + XNextBlock$
        IF XBlockSize% = 128 THEN
          XNextBlock$ = CHR$(1) + XNextBlock$
        ELSE
          XNextBlock$ = CHR$(2) + XNextBlock$
        END IF
        IF XBlockk$ = "" THEN
          XBlockk$ = XNextBlock$
          TCWrite XBlockk$
          XSendBlock% = -1
          XBlockNum% = XBlockNum% + 1
        END IF
      END IF
    END IF
    Char$ = TCInkey$
    SELECT CASE Char$
    CASE ACK$
      IF TCOutStat% = 0 AND LEN(XBlock$) = 0 THEN
        XFilePos& = XFilePos& + XBlockSize%
        IF XFilePos& >= XFileSize& THEN
          TCWrite EOT$
          XUpdate XFilePos&
          XTimeOut& = Time&
          EXIT DO
        ELSE
          IF XFer% = 2 THEN
            IF XBlockSize% > 128 THEN
              IF XFileSize& - XFilePos& + 128 <= 1024 THEN XBlockSize% = 128
            END IF
          END IF
        END IF
        XBlockk$ = XNextBlock$
        TCWrite XBlockk$
        XUpdate XFilePos&
        XBlockNum% = XBlockNum% + 1
        XStop% = 0
        XErrors% = 0
        XSendBlock% = -1
        XTimeOut& = Time&
      END IF
    CASE NAK$
      IF TCOutStat% = 0 AND LEN(XBlock$) = 0 THEN
        IF XErrors% = 10 THEN XMessage -13: EXIT SUB
        XStop% = 0
        XMessage 2
        XErrors% = XErrors% + 1
        TCWrite XBlockk$
        XTimeOut& = Time&
      END IF
    CASE CAN$
      XStop% = XStop% + 1
      IF XStop% = 2 THEN XMessage -12: EXIT SUB
    END SELECT
    IF TimeDiff&(XTimeOut&) > XBeginLim& THEN XMessage -15: EXIT SUB
  LOOP
  XErrors% = 0
  XStop% = 0
  XTimeOut& = Time&
  DO
    IF TCCarrier% = 0 THEN XMessage -11: EXIT SUB
    IF INKEY$ = CHR$(27) THEN XMessage -10: EXIT SUB
    Char$ = TCInkey$
    IF Char$ = NAK$ OR TimeDiff&(XTimeOut&) > XEndLim& THEN
      XErrors% = XErrors% + 1
      IF XErrors% >= 10 THEN XMessage -5: EXIT DO
      TCWrite EOT$
      XStop% = 0
      XTimeOut& = Time&
    ELSEIF Char$ = ACK$ THEN
      XMessage -1: EXIT DO
    ELSEIF Char$ = CAN$ THEN
      XStop% = XStop% + 1
      IF XStop% = 2 THEN XMessage -5: EXIT DO
    END IF
  LOOP
END SUB

SUB XUpdate (FilePos&)
  XTime& = TimeDiff&(XBegin&)
  XTimer& = XTime& / 100
  XTime3600% = INT(XTimer& / 3600)
  XTime60% = INT(XTimer& / 60& - XTime3600% * 60&)
  IF XTime3600% THEN Clock$ = RIGHT$("00" + LTRIM$(STR$(XTime3600%)), 2) + ":"
  Clock$ = RIGHT$("00" + LTRIM$(STR$(XTime60%)), 2)
  Clock$ = Clock$ + ":" + RIGHT$("00" + LTRIM$(STR$(XTimer& MOD 60)), 2)
  Print64 11, 12, Fo(XC3%) + Clock$
  Print64 12, 29, STR$(FilePos&)
  IF XTime& THEN
    CPS& = FilePos& / XTime& * 1000
    CPS$ = LTRIM$(STR$(CPS&))
    CPS$ = LEFT$(CPS$, LEN(CPS$) - 1) + "." + RIGHT$(CPS$, 1)
    Print64 12, 12, CPS$ + "   "
  ELSE
    Print64 12, 12, "0.0     "
  END IF

END SUB

